/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.TemplateAddDto;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.base.remote.service.IRemoteTemplateService;
import com.bizvane.message.api.model.dto.MsgSmsTemplateRemoteAddRequestParam;
import com.bizvane.message.api.model.dto.template.MsgSmsTemplateRemoteQueryRequestParam;
import com.bizvane.message.api.model.dto.template.sms.MsgSmsMultiListSendTemplateRequestParam;
import com.bizvane.message.domain.enums.ChannelTypeEnum;
import com.bizvane.message.domain.enums.SmsTemplateTypeEnum;
import com.bizvane.message.domain.model.bo.SmsTemplateBO;
import com.bizvane.message.domain.model.bo.TemplateTypeBO;
import com.bizvane.message.domain.service.IMsgMenuPlaceholderRelService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RemoteTemplateWrapperService {
    private IRemoteTemplateService iRemoteTemplateService;
    private IMsgMenuPlaceholderRelService msgMenuPlaceholderRelService;

    public String getMerchantIds() {
        return "0001";
    }

    public String getMerchantId() {
        return "0001";
    }

    public String getSignature() {
        return "TEST\u7b7e\u540d";
    }

    public ListResultBean<TemplateDto> getTemplateDtoListResultBean(MsgSmsMultiListSendTemplateRequestParam requestParam, String merchantIds) {
        ListResultBean resultBean = this.iRemoteTemplateService.queryTemplatePageMultiMerchant(merchantIds, requestParam.getTemplateCode(), null != requestParam.getTemplateType() ? requestParam.getTemplateType() + "" : null, requestParam.getStatus(), requestParam.getTemplateName(), requestParam.getSysCode(), requestParam.getRemark(), Long.valueOf(requestParam.getPageNum().longValue()), Long.valueOf(requestParam.getPageSize().longValue()));
        if (CollectionUtils.isEmpty((Collection)resultBean.getResult())) {
            return resultBean;
        }
        return resultBean;
    }

    public ResponseData<TemplateDto> getRemoteTemplateByTemplateCode(MsgSmsTemplateRemoteQueryRequestParam requestParam) {
        Integer channelTypeCode;
        String channelType;
        ResultBean merchantIdResponseData = this.iRemoteTemplateService.getMerchantIdByTemplateCode(requestParam.getTemplateCode());
        if (merchantIdResponseData == null || StringUtils.isBlank((CharSequence)((CharSequence)((Object)merchantIdResponseData.getResult())))) {
            return ResponseUtil.fail((String)"\u5546\u6237id\u83b7\u53d6\u4e3a\u7a7a!");
        }
        String merchantId = (String)((Object)merchantIdResponseData.getResult());
        ResultBean resultBean = this.iRemoteTemplateService.queryTemplate(merchantId, channelType = ChannelTypeEnum.getCode(channelTypeCode = null), requestParam.getTemplateCode());
        if (resultBean.getSuccess().booleanValue()) {
            return ResponseUtil.success((Object)resultBean.getResult());
        }
        return ResponseUtil.fail((String)resultBean.getErrorInfo().getMsg());
    }

    public ResponseData<TemplateDto> addTemplate(MsgSmsTemplateRemoteAddRequestParam requestParam) {
        SmsTemplateBO smsTemplateBO = new SmsTemplateBO();
        BeanUtils.copyProperties((Object)requestParam, (Object)smsTemplateBO);
        Integer channelTypeCode = null;
        String channelType = ChannelTypeEnum.getCode(channelTypeCode);
        String sign = null;
        String unsubscribeText = null;
        smsTemplateBO.setChannelType(channelType);
        smsTemplateBO.setSign(sign);
        if (SmsTemplateTypeEnum.SMS_YX.getType().equals(requestParam.getTemplateType())) {
            smsTemplateBO.setPostFix(unsubscribeText);
        }
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String sysCode = SmsTemplateTypeEnum.getCode((String)requestParam.getTemplateType()) + formatter.format(now) + (int)((Math.random() * 9.0 + 1.0) * 1000.0);
        smsTemplateBO.setSysCode(sysCode);
        this.convertAttachContent(smsTemplateBO);
        ResultBean result = this.iRemoteTemplateService.createTemplateNew(new TemplateAddDto(smsTemplateBO.getMerchantId(), smsTemplateBO.getChannelType(), smsTemplateBO.getTemplateName(), smsTemplateBO.getTemplateType() + "", smsTemplateBO.getTemplateContent(), smsTemplateBO.getRemark(), smsTemplateBO.getPostFix(), smsTemplateBO.getSysCode(), smsTemplateBO.getSign(), smsTemplateBO.getOriginalContent(), smsTemplateBO.getAttach()));
        if (result == null) {
            return ResponseUtil.fail((String)"\u521b\u5efa\u77ed\u4fe1\u6a21\u677f\u5931\u8d25!");
        }
        if (result.getSuccess().booleanValue()) {
            return ResponseUtil.fail((String)result.getErrorInfo().getMsg());
        }
        return ResponseUtil.success((Object)result.getResult());
    }

    private void convertAttachContent(SmsTemplateBO smsTemplateBO) {
        String[] replaces;
        String origin = smsTemplateBO.getOriginalContent();
        List templateTypeBOS = this.msgMenuPlaceholderRelService.findByTemplateType(smsTemplateBO.getTemplateType());
        if (CollectionUtils.isEmpty((Collection)templateTypeBOS)) {
            smsTemplateBO.setTemplateContent(origin);
            return;
        }
        for (TemplateTypeBO templateTypeBO : templateTypeBOS) {
            Matcher matcher = Pattern.compile("@\\[" + templateTypeBO.getPlaceholderName() + "\\]").matcher(origin);
            if (!matcher.find()) continue;
            origin = origin.replaceFirst("@\\[" + templateTypeBO.getPlaceholderName() + "\\]", "\\${\\" + templateTypeBO.getPlaceholderKey() + "\\}");
        }
        JSONObject jsonObject = new JSONObject(true);
        for (String replace : replaces = origin.split("\\$\\{")) {
            for (TemplateTypeBO templateTypeBO : templateTypeBOS) {
                if (!replace.contains(templateTypeBO.getPlaceholderKey())) continue;
                jsonObject.put(templateTypeBO.getPlaceholderKey(), (Object)"");
            }
        }
        smsTemplateBO.setAttach(jsonObject.toJSONString());
        smsTemplateBO.setTemplateContent(origin);
    }
}

