/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.subscribe;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.api.model.dto.MsgWxMiniSubscribeRecordFindDTO;
import com.bizvane.message.api.model.dto.WxMiniSubscribeSendBusinessDTO;
import com.bizvane.message.api.model.vo.subscribe.MsgWxMiniSubscribeSyncSendResponseVO;
import com.bizvane.message.api.model.vo.subscribe.mq.WxMiniSubscribeWrapperVO;
import com.bizvane.message.api.service.MsgWxMiniSubscribeBusinessService;
import com.bizvane.message.domain.model.bo.WeChatSubscribeParamBO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempFieldPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeRecordPO;
import com.bizvane.message.domain.service.IMsgWxMiniProTempFieldService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class WxMiniSubscribeSendComponent {
    private final MsgWxMiniSubscribeBusinessService msgWxMiniSubscribeBusinessService;
    private final IMsgWxMiniProTempService msgWxMiniProTempService;
    private final IMsgWxMiniProTempFieldService iMsgWxMiniProTempFieldService;

    public ResponseData<MsgWxMiniSubscribeSyncSendResponseVO> send(WxMiniSubscribeWrapperVO<?> subscribeWrapperVO, String templateType) {
        MsgWxMiniSubscribeRecordFindDTO paramDto = new MsgWxMiniSubscribeRecordFindDTO();
        paramDto.setOpenId(templateType);
        paramDto.setTemplateType(templateType);
        paramDto.setLikeUrl(subscribeWrapperVO.getLinkUrl());
        paramDto.setBusinessParamJson(JSON.parseObject((String)JSON.toJSONString(subscribeWrapperVO.getMessageInfo())));
        String openId = this.getOpenIdByMemberCode(subscribeWrapperVO.getMemberCode());
        paramDto.setOpenId(openId);
        return this.send(paramDto);
    }

    private String getOpenIdByMemberCode(String memberCode) {
        return null;
    }

    private ResponseData<MsgWxMiniSubscribeSyncSendResponseVO> send(MsgWxMiniSubscribeRecordFindDTO paramDto) {
        MsgWxMiniSubscribeRecordPO subscribeRecord = this.msgWxMiniSubscribeBusinessService.findSubscribeRecord(paramDto);
        if (subscribeRecord == null) {
            return ResponseUtil.fail((String)"\u672a\u5339\u914d\u5230\u8ba2\u9605\u8bb0\u5f55,\u4e0d\u53d1\u9001");
        }
        MsgWxMiniProTempPO msgWxMiniProTempPO = this.msgWxMiniProTempService.selectOneByTemplateType(paramDto.getTemplateType());
        if (msgWxMiniProTempPO == null) {
            return ResponseUtil.fail((String)"\u672a\u5339\u914d\u5230\u5c0f\u7a0b\u5e8f\u6a21\u677f\u4fe1\u606f,\u4e0d\u53d1\u9001");
        }
        List msgWxMiniProTempFieldPOS = this.iMsgWxMiniProTempFieldService.selectListByMsgWxMiniProTempCode(msgWxMiniProTempPO.getMsgWxMiniProTempCode());
        if (CollectionUtils.isEmpty((Collection)msgWxMiniProTempFieldPOS)) {
            return ResponseUtil.fail((String)"\u5c0f\u7a0b\u5e8f\u6a21\u677f\u672a\u8bbe\u7f6e\u5b57\u6bb5\u4fe1\u606f,\u4e0d\u53d1\u9001");
        }
        WeChatSubscribeParamBO wxSubscribeMessage = this.builderWxSubscribeMessage(paramDto.getBusinessParamJson(), msgWxMiniProTempFieldPOS, msgWxMiniProTempPO, subscribeRecord);
        WxMiniSubscribeSendBusinessDTO wxMiniSubscribeSendBusinessDTO = new WxMiniSubscribeSendBusinessDTO(subscribeRecord, msgWxMiniProTempPO, msgWxMiniProTempFieldPOS, wxSubscribeMessage);
        this.msgWxMiniSubscribeBusinessService.saveSentRecord(wxMiniSubscribeSendBusinessDTO);
        return ResponseUtil.success((Object)new MsgWxMiniSubscribeSyncSendResponseVO(), (String)"\u9ed8\u8ba4\u53d1\u9001\u6210\u529f!");
    }

    private WeChatSubscribeParamBO builderWxSubscribeMessage(JSONObject businessParam, List<MsgWxMiniProTempFieldPO> msgWxMiniProTempFieldPOS, MsgWxMiniProTempPO msgWxMiniProTempPO, MsgWxMiniSubscribeRecordPO subscribeRecord) {
        JSONObject dataFieldMessage = new JSONObject();
        for (MsgWxMiniProTempFieldPO msgWxMiniProTempFieldPO : msgWxMiniProTempFieldPOS) {
            String jsonFieldValue;
            String jsonFieldName = msgWxMiniProTempFieldPO.getJsonFieldName();
            if ("TEXT".equals(msgWxMiniProTempFieldPO.getLocalFieldName())) {
                jsonFieldValue = (String)businessParam.getOrDefault((Object)jsonFieldName, (Object)"");
                dataFieldMessage.put(jsonFieldName, (Object)jsonFieldValue);
                continue;
            }
            jsonFieldValue = msgWxMiniProTempFieldPO.getLocalFieldValue();
            dataFieldMessage.put(jsonFieldName, (Object)jsonFieldValue);
        }
        WeChatSubscribeParamBO weChatSubscribeParamBO = new WeChatSubscribeParamBO();
        weChatSubscribeParamBO.setToUser(subscribeRecord.getFromUserName());
        weChatSubscribeParamBO.setTemplateId(subscribeRecord.getTemplateId());
        weChatSubscribeParamBO.setLang("zh_CN");
        weChatSubscribeParamBO.setData(dataFieldMessage.toJSONString());
        if (dataFieldMessage.containsKey((Object)"linkUrl")) {
            weChatSubscribeParamBO.setPage(dataFieldMessage.getString("linkUrl"));
        } else if (StringUtils.isNotBlank((CharSequence)msgWxMiniProTempPO.getUrl())) {
            weChatSubscribeParamBO.setPage(msgWxMiniProTempPO.getUrl());
        }
        return weChatSubscribeParamBO;
    }

    public WxMiniSubscribeSendComponent(MsgWxMiniSubscribeBusinessService msgWxMiniSubscribeBusinessService, IMsgWxMiniProTempService msgWxMiniProTempService, IMsgWxMiniProTempFieldService iMsgWxMiniProTempFieldService) {
        this.msgWxMiniSubscribeBusinessService = msgWxMiniSubscribeBusinessService;
        this.msgWxMiniProTempService = msgWxMiniProTempService;
        this.iMsgWxMiniProTempFieldService = iMsgWxMiniProTempFieldService;
    }
}

