/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.bizvane.message.api.model.vo.sms.SmsCallBackVO;
import com.bizvane.message.api.model.vo.sms.mq.MsgSmsSentBatchMessageVO;
import com.bizvane.message.api.model.vo.sms.mq.SmsResendMessageVO;
import com.bizvane.message.api.model.vo.subscribe.WxMiniSubscribeMessageVO;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.domain.enums.SmsTopicEnum;
import com.bizvane.message.domain.enums.WeChatAppletSubscribeTopicEnum;
import com.bizvane.message.domain.enums.WeChatSubscribeTopicEnum;
import com.bizvane.message.domain.model.entity.MsgSendtimePO;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.stereotype.Service;

@Service
public class RocketMQBusinessServiceImpl
implements RocketMQBusinessService {
    private RocketMQTemplate rocketMQTemplate;

    @Override
    public SendResult sendWechatSubscribe(WxMiniSubscribeMessageVO wxMiniSubscribeMessageVO, WeChatAppletSubscribeTopicEnum subscribeTopicEnum) {
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(subscribeTopicEnum.getTopic()).tag(subscribeTopicEnum.getTag()).build(), (Object)JSON.toJSONString((Object)wxMiniSubscribeMessageVO));
        return sendResult;
    }

    @Override
    public SendResult sendWechatSubscribeAsyncSend(String requestVo, WeChatSubscribeTopicEnum weChatSubscribeTopicEnum) {
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(weChatSubscribeTopicEnum.getTopic()).tag(weChatSubscribeTopicEnum.getTag()).build(), (Object)requestVo);
        return sendResult;
    }

    @Override
    public SendResult sendWechatSubscribeResend(String requestVo, WeChatSubscribeTopicEnum weChatSubscribeTopicEnum, MsgSendtimePO inSendTime) {
        MessageDelayLevel messageDelayLevel = this.convertMessageDelayLevel(inSendTime);
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().delayLevel(messageDelayLevel).topic(weChatSubscribeTopicEnum.getTopic()).tag(weChatSubscribeTopicEnum.getTag()).build(), (Object)requestVo);
        return sendResult;
    }

    @Override
    public SendResult sendSmsCallBack(SmsCallBackVO smsCallBackVO) {
        SmsTopicEnum smsTopicEnum = SmsTopicEnum.CALL_BACK;
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(smsTopicEnum.getTopic()).tag(smsTopicEnum.getTag()).build(), (Object)JSON.toJSONString((Object)smsCallBackVO));
        return sendResult;
    }

    @Override
    public SendResult sendSmsSentBatch(MsgSmsSentBatchMessageVO messageVO) {
        SmsTopicEnum smsTopicEnum = SmsTopicEnum.SENT_BATCH;
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(smsTopicEnum.getTopic()).tag(smsTopicEnum.getTag()).build(), (Object)JSON.toJSONString((Object)messageVO));
        return sendResult;
    }

    @Override
    public SendResult sendSmsMessage(SmsResendMessageVO messageVO) {
        SmsTopicEnum smsTopicEnum = SmsTopicEnum.SENT_BATCH;
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(smsTopicEnum.getTopic()).tag(smsTopicEnum.getTag()).build(), (Object)JSON.toJSONString((Object)messageVO));
        return sendResult;
    }

    private MessageDelayLevel convertMessageDelayLevel(MsgSendtimePO sendtimePO) {
        LocalTime sendTimeStart = sendtimePO.getSendTimeStart();
        LocalTime now = LocalTime.now();
        long untilHours = now.until(sendTimeStart, ChronoUnit.HOURS);
        if (untilHours >= 2L) {
            return MessageDelayLevel._2h;
        }
        if (untilHours >= 1L) {
            return MessageDelayLevel._1h;
        }
        long untilMinutes = now.until(sendTimeStart, ChronoUnit.MINUTES);
        if (untilMinutes >= 30L) {
            return MessageDelayLevel._1h;
        }
        if (untilMinutes >= 20L) {
            return MessageDelayLevel._30m;
        }
        if (untilMinutes >= 10L) {
            return MessageDelayLevel._20m;
        }
        if (untilMinutes >= 9L) {
            return MessageDelayLevel._10m;
        }
        if (untilMinutes >= 8L) {
            return MessageDelayLevel._9m;
        }
        if (untilMinutes >= 7L) {
            return MessageDelayLevel._8m;
        }
        if (untilMinutes >= 6L) {
            return MessageDelayLevel._7m;
        }
        if (untilMinutes >= 5L) {
            return MessageDelayLevel._6m;
        }
        if (untilMinutes >= 4L) {
            return MessageDelayLevel._5m;
        }
        if (untilMinutes >= 3L) {
            return MessageDelayLevel._4m;
        }
        if (untilMinutes >= 2L) {
            return MessageDelayLevel._3m;
        }
        if (untilMinutes >= 1L) {
            return MessageDelayLevel._2m;
        }
        long untilSeconds = now.until(sendTimeStart, ChronoUnit.SECONDS);
        if (untilSeconds >= 30L) {
            return MessageDelayLevel._1m;
        }
        if (untilSeconds >= 10L) {
            return MessageDelayLevel._30s;
        }
        return MessageDelayLevel._10s;
    }
}

