/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempEditStatusRequestParam;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempListRequestParam;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempListResponseVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempFieldVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempPlaceholderRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempPlaceholderResponseVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailEditRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailFieldEditRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailResponseVO;
import com.bizvane.message.api.service.MsgWeChatMiniProTemplateService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.enums.msg.MsgTemplateTypeMap;
import com.bizvane.message.domain.model.bo.MsgWxMiniProTempBO;
import com.bizvane.message.domain.model.bo.MsgWxMiniProTempFieldBO;
import com.bizvane.message.domain.model.bo.WeChatMiniProTempEditBO;
import com.bizvane.message.domain.model.bo.WeChatMiniProTempQueryBO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempTemplateTypePO;
import com.bizvane.message.domain.service.IMsgWxMiniProTempFieldService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempPlaceholderService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempTemplateTypeService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MsgWeChatMiniProTemplateServiceImpl
implements MsgWeChatMiniProTemplateService {
    private final StringRedisTemplate redisTemplate;
    private final IMsgWxMiniProTempService msgWxMiniProTempService;
    private final OptUserService optUserService;
    private final IMsgWxMiniProTempFieldService msgWxMiniProTempFieldService;
    private final IMsgWxMiniProTempPlaceholderService msgWxMiniProTempPlaceholderService;
    private final IMsgWxMiniProTempTemplateTypeService msgWxMiniProTempTemplateTypeService;

    @Override
    public ResponseData<List<WeChatMiniProTempListResponseVO>> getWeChatMiniProTemplateFromWechat(WeChatMiniProTempListRequestParam requestParam) {
        String uid = "example";
        String list = (String)this.redisTemplate.opsForValue().get((Object)("WXMiniProTemp_" + uid));
        if (StringUtils.isNotBlank((CharSequence)list)) {
            List resultList = JSON.parseArray((String)list, WeChatMiniProTempListResponseVO.class);
            return new ResponseData((Object)resultList);
        }
        String weChatMiniProAccessToken = null;
        List<WeChatMiniProTempListResponseVO> weChatMiniProTemplateData = this.getWeChatMiniProTemplateData(weChatMiniProAccessToken);
        this.redisTemplate.opsForValue().set((Object)("WXMiniProTemp_" + uid), (Object)JSON.toJSONString(weChatMiniProTemplateData), 60L, TimeUnit.MINUTES);
        return new ResponseData(weChatMiniProTemplateData);
    }

    @Override
    public ResponseData<Boolean> updateSceneOpenJudge(WeChatMiniProTempEditStatusRequestParam requestParam) {
        AssertUtil.notNull((Object)requestParam.getOpenJudge(), requestParam.getMsgWxMiniProTempCode());
        OptUserDTO optUser = this.optUserService.getOptUser();
        WeChatMiniProTempEditBO weChatMiniProTempEditBO = new WeChatMiniProTempEditBO();
        weChatMiniProTempEditBO.setOpenJudge(requestParam.getOpenJudge());
        weChatMiniProTempEditBO.setMsgWxMiniProTempCode(requestParam.getMsgWxMiniProTempCode());
        weChatMiniProTempEditBO.setOptUserCode(optUser.getOptUserCode());
        weChatMiniProTempEditBO.setOptUserName(optUser.getOptUserName());
        Boolean result = this.msgWxMiniProTempService.updateBrandSceneOpenJudge(weChatMiniProTempEditBO);
        return new ResponseData((Object)result);
    }

    @Override
    public ResponseData<List<MsgWxMiniProTempPlaceholderResponseVO>> findPlaceHolderByTemplateType(MsgWxMiniProTempPlaceholderRequestVO requestParam) {
        AssertUtil.notNull(requestParam.getTemplateType());
        MsgWxMiniProTempTemplateTypePO miniProTempTemplateTypePO = this.msgWxMiniProTempTemplateTypeService.findByWxMiniProTempTemplateType(requestParam.getTemplateType());
        return this.getMsgWxMiniProTempPlaceholderList(miniProTempTemplateTypePO);
    }

    @Override
    public ResponseData<WeChatMiniProTempDetailResponseVO> getSingleTemplate(WeChatMiniProTempDetailRequestVO requestVO) {
        AssertUtil.notNull(requestVO.getTemplateType());
        AssertUtil.judge(MsgTemplateTypeMap.containsKey((Object)requestVO.getTemplateType()), "templateType\u4e0d\u5b58\u5728");
        String businessType = MsgTemplateTypeMap.getKey((Object)requestVO.getTemplateType()).getBusinessTypeEnum().getCode();
        WeChatMiniProTempQueryBO weChatMiniProTempQueryBO = new WeChatMiniProTempQueryBO();
        weChatMiniProTempQueryBO.setTemplateType(requestVO.getTemplateType());
        weChatMiniProTempQueryBO.setBusinessType(businessType);
        MsgWxMiniProTempPO msgWxMiniProTempPO = this.msgWxMiniProTempService.selectOne(weChatMiniProTempQueryBO);
        if (msgWxMiniProTempPO == null) {
            return ResponseUtil.success((Object)new WeChatMiniProTempDetailResponseVO());
        }
        WeChatMiniProTempDetailResponseVO weChatMiniProTempDetailResponseVO = new WeChatMiniProTempDetailResponseVO();
        BeanUtils.copyProperties((Object)msgWxMiniProTempPO, (Object)weChatMiniProTempDetailResponseVO);
        List msgWxMiniProTempFieldPOS = this.msgWxMiniProTempFieldService.selectListByMsgWxMiniProTempCode(msgWxMiniProTempPO.getMsgWxMiniProTempCode());
        if (CollectionUtils.isNotEmpty((Collection)msgWxMiniProTempFieldPOS)) {
            List<MsgWxMiniProTempFieldVO> msgWxMiniProTempFieldVOS = msgWxMiniProTempFieldPOS.stream().map(msgWxMiniProTempFieldPO -> {
                MsgWxMiniProTempFieldVO msgWxMiniProTempFieldVO = new MsgWxMiniProTempFieldVO();
                BeanUtils.copyProperties((Object)msgWxMiniProTempFieldPO, (Object)msgWxMiniProTempFieldVO);
                return msgWxMiniProTempFieldVO;
            }).collect(Collectors.toList());
            weChatMiniProTempDetailResponseVO.setFieldList(msgWxMiniProTempFieldVOS);
        }
        return new ResponseData((Object)weChatMiniProTempDetailResponseVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> saveOrUpdateTemplate(WeChatMiniProTempDetailEditRequestVO requestVO) {
        AssertUtil.notEmpty(requestVO.getFieldList());
        AssertUtil.notNull(requestVO.getWxTempId(), requestVO.getWxTempTitle(), requestVO.getWxTempType(), requestVO.getTemplateType());
        AssertUtil.judge(MsgTemplateTypeMap.containsKey((Object)requestVO.getTemplateType()), "templateType\u4e0d\u5b58\u5728");
        String businessType = MsgTemplateTypeMap.getKey((Object)requestVO.getTemplateType()).getBusinessTypeEnum().getCode();
        requestVO.setBusinessType(businessType);
        WeChatMiniProTempQueryBO weChatMiniProTempQueryBO = new WeChatMiniProTempQueryBO();
        weChatMiniProTempQueryBO.setTemplateType(requestVO.getTemplateType());
        weChatMiniProTempQueryBO.setBusinessType(businessType);
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgWxMiniProTempPO msgWxMiniProTempPO = this.msgWxMiniProTempService.selectOne(weChatMiniProTempQueryBO);
        if (msgWxMiniProTempPO != null) {
            requestVO.setMsgWxMiniProTempCode(msgWxMiniProTempPO.getMsgWxMiniProTempCode());
            this.deleteOldTemplate(requestVO, optUser);
        }
        Boolean result = this.addTemplate(requestVO, optUser);
        return new ResponseData((Object)result);
    }

    private void deleteOldTemplate(WeChatMiniProTempDetailEditRequestVO requestVO, OptUserDTO optUser) {
        WeChatMiniProTempEditBO weChatMiniProTempEditBO = new WeChatMiniProTempEditBO();
        weChatMiniProTempEditBO.setOptUserName(optUser.getOptUserName());
        weChatMiniProTempEditBO.setOptUserCode(optUser.getOptUserCode());
        weChatMiniProTempEditBO.setMsgWxMiniProTempCode(requestVO.getMsgWxMiniProTempCode());
        this.msgWxMiniProTempService.deleteMsgWxMiniProTemp(weChatMiniProTempEditBO);
        this.msgWxMiniProTempFieldService.deleteByMsgWxMiniProTempCode(weChatMiniProTempEditBO);
    }

    private Boolean addTemplate(WeChatMiniProTempDetailEditRequestVO requestVO, OptUserDTO optUser) {
        MsgWxMiniProTempBO msgWxMiniProTempBO = new MsgWxMiniProTempBO();
        BeanUtils.copyProperties((Object)requestVO, (Object)msgWxMiniProTempBO);
        msgWxMiniProTempBO.setCreateUserCode(optUser.getOptUserCode());
        msgWxMiniProTempBO.setCreateUserName(optUser.getOptUserName());
        msgWxMiniProTempBO.setMsgWxMiniProTempCode(UID.getUid());
        Boolean resultA = this.msgWxMiniProTempService.addMsgWxMiniProTemp(msgWxMiniProTempBO);
        List fieldBOList = requestVO.getFieldList().stream().map(msgWxMiniProTempFieldVO -> {
            MsgWxMiniProTempFieldBO msgWxMiniProTempFieldBO = new MsgWxMiniProTempFieldBO();
            BeanUtils.copyProperties((Object)msgWxMiniProTempFieldVO, (Object)msgWxMiniProTempFieldBO);
            msgWxMiniProTempFieldBO.setCreateUserCode(msgWxMiniProTempBO.getCreateUserCode());
            msgWxMiniProTempFieldBO.setCreateUserName(msgWxMiniProTempBO.getCreateUserName());
            msgWxMiniProTempFieldBO.setCreateDate(LocalDateTime.now());
            msgWxMiniProTempFieldBO.setMsgWxMiniProTempCode(msgWxMiniProTempBO.getMsgWxMiniProTempCode());
            msgWxMiniProTempFieldBO.setMsgWxMiniProTempFieldCode(UID.getUid());
            return msgWxMiniProTempFieldBO;
        }).collect(Collectors.toList());
        Boolean resultB = this.msgWxMiniProTempFieldService.addBath(fieldBOList);
        return resultA != false && resultB != false;
    }

    private void checkFieldList(WeChatMiniProTempDetailEditRequestVO requestVO) {
        List<WeChatMiniProTempDetailFieldEditRequestVO> fieldList = requestVO.getFieldList();
        AssertUtil.notEmpty(fieldList);
    }

    private List<WeChatMiniProTempListResponseVO> getWeChatMiniProTemplateData(String accessToken) {
        return null;
    }

    private ResponseData<List<MsgWxMiniProTempPlaceholderResponseVO>> getMsgWxMiniProTempPlaceholderList(MsgWxMiniProTempTemplateTypePO miniProTempTemplateTypePO) {
        if (miniProTempTemplateTypePO != null) {
            List msgWxMiniProTempPlaceholderPOS = this.msgWxMiniProTempPlaceholderService.selectPlaceHolderByTemplateType(miniProTempTemplateTypePO.getTemplateType());
            List resultList = msgWxMiniProTempPlaceholderPOS.stream().map(msgWxMiniProTempPlaceholderBO -> {
                MsgWxMiniProTempPlaceholderResponseVO msgWxMiniProTempPlaceholderResponseVO = new MsgWxMiniProTempPlaceholderResponseVO();
                BeanUtils.copyProperties((Object)msgWxMiniProTempPlaceholderBO, (Object)msgWxMiniProTempPlaceholderResponseVO);
                return msgWxMiniProTempPlaceholderResponseVO;
            }).collect(Collectors.toList());
            return ResponseUtil.success(resultList);
        }
        return ResponseUtil.success(new ArrayList());
    }

    public MsgWeChatMiniProTemplateServiceImpl(StringRedisTemplate redisTemplate, IMsgWxMiniProTempService msgWxMiniProTempService, OptUserService optUserService, IMsgWxMiniProTempFieldService msgWxMiniProTempFieldService, IMsgWxMiniProTempPlaceholderService msgWxMiniProTempPlaceholderService, IMsgWxMiniProTempTemplateTypeService msgWxMiniProTempTemplateTypeService) {
        this.redisTemplate = redisTemplate;
        this.msgWxMiniProTempService = msgWxMiniProTempService;
        this.optUserService = optUserService;
        this.msgWxMiniProTempFieldService = msgWxMiniProTempFieldService;
        this.msgWxMiniProTempPlaceholderService = msgWxMiniProTempPlaceholderService;
        this.msgWxMiniProTempTemplateTypeService = msgWxMiniProTempTemplateTypeService;
    }
}

