/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.bizvane.message.api.model.dto.template.MsgTemplateMenuPlaceHolderRequestParam;
import com.bizvane.message.api.model.dto.template.MsgTemplateRemindQueryRequestParam;
import com.bizvane.message.api.model.dto.template.sms.MsgTemplateRemindSaveRequestParam;
import com.bizvane.message.api.model.vo.template.MsgRemindVO;
import com.bizvane.message.api.service.MsgRemindService;
import com.bizvane.message.api.service.MsgTemplateService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.service.IMsgMenuPlaceholderRelService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgTemplateServiceImpl
implements MsgTemplateService {
    private final IMsgMenuPlaceholderRelService msgMenuPlaceholderRelService;
    private final MsgRemindService msgRemindService;

    @Override
    public ResponseData<List<String>> getMsgMenuPlaceHolder(MsgTemplateMenuPlaceHolderRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getTemplateType());
        List templateTypeBOS = this.msgMenuPlaceholderRelService.findByTemplateType(requestParam.getTemplateType());
        ArrayList<String> namelist = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)templateTypeBOS)) {
            templateTypeBOS.stream().forEach(templateTypeBO -> namelist.add(templateTypeBO.getMenuName()));
            namelist.add("\u81ea\u5b9a\u4e49\u6587\u672c");
        }
        return new ResponseData(namelist);
    }

    @Override
    public ResponseData<MsgRemindVO> getMsgRemind(MsgTemplateRemindQueryRequestParam requestParam) {
        return this.msgRemindService.getMsgRemind(requestParam);
    }

    @Override
    public ResponseData<Boolean> saveMsgRemind(MsgTemplateRemindSaveRequestParam requestParam) {
        return this.msgRemindService.saveMsgRemind(requestParam);
    }

    public MsgTemplateServiceImpl(IMsgMenuPlaceholderRelService msgMenuPlaceholderRelService, MsgRemindService msgRemindService) {
        this.msgMenuPlaceholderRelService = msgMenuPlaceholderRelService;
        this.msgRemindService = msgRemindService;
    }
}

