/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.dto.template.MsgTemplateRemindQueryRequestParam;
import com.bizvane.message.api.model.dto.template.sms.MsgTemplateRemindSaveRequestParam;
import com.bizvane.message.api.model.vo.template.MsgRemindVO;
import com.bizvane.message.api.service.MsgRemindService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.enums.msg.MsgSendTimeTemplateTypeMap;
import com.bizvane.message.domain.model.entity.MsgRemindPO;
import com.bizvane.message.domain.service.IMsgRemindService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgRemindWrapperServiceImpl
implements MsgRemindService {
    private final IMsgRemindService msgRemindService;
    private final OptUserService optUserService;

    @Override
    public ResponseData<MsgRemindVO> getMsgRemind(MsgTemplateRemindQueryRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getTemplateType());
        AssertUtil.judge(MsgSendTimeTemplateTypeMap.containsKey((Object)requestParam.getTemplateType()), "templateType\u4e0d\u5b58\u5728!");
        MsgRemindPO msgRemindPO = this.msgRemindService.selectOneByTemplateType(requestParam.getTemplateType());
        MsgRemindVO result = new MsgRemindVO();
        if (msgRemindPO != null) {
            BeanUtils.copyProperties((Object)msgRemindPO, (Object)result);
        }
        return ResponseUtil.success((Object)result);
    }

    @Override
    public ResponseData<Boolean> saveMsgRemind(MsgTemplateRemindSaveRequestParam requestParam) {
        AssertUtil.notNull("", requestParam.getTemplateType(), requestParam.getDays());
        AssertUtil.judge(MsgSendTimeTemplateTypeMap.containsKey((Object)requestParam.getTemplateType()), "templateType\u4e0d\u5b58\u5728!");
        MsgRemindPO msgRemindPO = this.msgRemindService.selectOneByTemplateType(requestParam.getTemplateType());
        if (msgRemindPO != null) {
            return this.updateMsgRemind(requestParam, msgRemindPO);
        }
        return this.addMsgRemind(requestParam);
    }

    private ResponseData addMsgRemind(MsgTemplateRemindSaveRequestParam requestParam) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        String bussinessType = MsgSendTimeTemplateTypeMap.getKey((Object)requestParam.getTemplateType()).getBusinessTypeEnum().getCode();
        MsgRemindPO msgRemindPOAdd = new MsgRemindPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgRemindPOAdd);
        msgRemindPOAdd.setCreateUserCode(optUser.getOptUserCode());
        msgRemindPOAdd.setCreateUserName(optUser.getOptUserName());
        msgRemindPOAdd.setBusinessType(bussinessType);
        msgRemindPOAdd.setMsgRemindCode(UID.getUid());
        Boolean result = this.msgRemindService.addPO(msgRemindPOAdd);
        return ResponseUtil.success((Object)result);
    }

    private ResponseData updateMsgRemind(MsgTemplateRemindSaveRequestParam requestParam, MsgRemindPO msgRemindPO) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgRemindPO msgRemindPOUpdate = new MsgRemindPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgRemindPOUpdate);
        msgRemindPOUpdate.setModifiedUserCode(optUser.getOptUserCode());
        msgRemindPOUpdate.setModifiedUserName(optUser.getOptUserName());
        msgRemindPOUpdate.setMsgRemindCode(msgRemindPO.getMsgRemindCode());
        Boolean result = this.msgRemindService.updatePO(msgRemindPOUpdate);
        return ResponseUtil.success((Object)result);
    }

    public MsgRemindWrapperServiceImpl(IMsgRemindService msgRemindService, OptUserService optUserService) {
        this.msgRemindService = msgRemindService;
        this.optUserService = optUserService;
    }
}

