/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.api.model.vo.subscribe.mq.WxMiniSubscribeWrapperVO;
import com.bizvane.message.domain.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.domain.model.entity.MsgSendtimePO;
import com.bizvane.message.domain.service.IMsgSendtimeService;
import com.bizvane.utils.redisutils.SpringContextHolder;
import java.time.LocalTime;

public abstract class SubscribeMessageHelp<T> {
    MsgSendtimePO getInSendTime(String templateType) {
        boolean preventDisturbance = MsgTemplateTypeEnum.preventDisturbance((String)templateType);
        if (!preventDisturbance) {
            return null;
        }
        IMsgSendtimeService msgSendtimeService = (IMsgSendtimeService)SpringContextHolder.getBean(IMsgSendtimeService.class);
        MsgSendtimePO msgSendtimePO = msgSendtimeService.selectOne();
        if (msgSendtimePO == null) {
            return null;
        }
        LocalTime now = LocalTime.now();
        LocalTime sendTimeStart = msgSendtimePO.getSendTimeStart();
        LocalTime sendTimeEnd = msgSendtimePO.getSendTimeEnd();
        if (now.isBefore(sendTimeStart) || now.isAfter(sendTimeEnd)) {
            return null;
        }
        return msgSendtimePO;
    }

    public JSONObject getMessageInfo(String message) {
        return (JSONObject)((WxMiniSubscribeWrapperVO)JSON.parseObject((String)message, WxMiniSubscribeWrapperVO.class)).getMessageInfo();
    }

    public WxMiniSubscribeWrapperVO<T> convertSubscribeWrapperVO(String consumerMessageInfo, Class<T> cls) {
        WxMiniSubscribeWrapperVO wxMiniSubscribeWrapperVOOld = (WxMiniSubscribeWrapperVO)JSONObject.parseObject((String)consumerMessageInfo, WxMiniSubscribeWrapperVO.class);
        Object messageInfo = ((JSONObject)wxMiniSubscribeWrapperVOOld.getMessageInfo()).toJavaObject(cls);
        WxMiniSubscribeWrapperVO<Object> wxMiniSubscribeWrapperVO = new WxMiniSubscribeWrapperVO<Object>();
        wxMiniSubscribeWrapperVO.setMessageInfo(messageInfo);
        wxMiniSubscribeWrapperVO.setMemberCode(wxMiniSubscribeWrapperVOOld.getMemberCode());
        wxMiniSubscribeWrapperVO.setLinkUrl(wxMiniSubscribeWrapperVOOld.getLinkUrl());
        return wxMiniSubscribeWrapperVO;
    }

    public void handlerConsumerMessageInfo(MsgTemplateTypeEnum templateTypeEnum, String consumerMessageInfo) {
        MsgSendtimePO inSendTime = this.getInSendTime(templateTypeEnum.getCode());
        if (inSendTime != null) {
            this.resend(consumerMessageInfo, inSendTime);
        } else {
            this.handler(consumerMessageInfo);
        }
    }

    public abstract void resend(String var1, MsgSendtimePO var2);

    public abstract void handler(String var1);
}

