package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Data
public class MbrIntegralRegistrationListRequestParam {

    @ApiModelProperty("页面类型：1-待审核页面，2-已审核页面")
    private Integer pageType;

    @ApiModelProperty(value = "机场编号")
    private List<String> airportCodeList;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("创建时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty("创建时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateEnd;

    @ApiModelProperty("审核状态：1-通过，2-不通过")
    private Integer status;

    @ApiModelProperty("审核人姓名")
    private String reviewUserName;

    @ApiModelProperty("审核时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime reviewDateStart;

    @ApiModelProperty("审核时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime reviewDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}