package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityListRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("核销员工账号")
    private String useAccountCode;

    @ApiModelProperty("券code")
    private String couponEntityCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券定义编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券生成渠道：1-crm生成，2-外部系统")
    private Integer generationChannel;

    @ApiModelProperty("20-未使用，25-已过期，30-已核销，35-已作废")
    private Integer couponStatus;

    @ApiModelProperty("20-未使用，25-已过期，30-已核销，35-已作废")
    private List<Integer> couponStatusList;

    @ApiModelProperty("转赠状态：1-转增中，2-已完成，3-已撤回")
    private Integer giveStatus;

    @ApiModelProperty("任务名称")
    private String sendBusinessName;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @ApiModelProperty("核销商户编号")
    private List<String> useMerchantNoList;

    @ApiModelProperty("发放类型：枚举类CouponSendTypeEnum，字典coupon_send_type")
    private List<Integer> sendTypeList;

    @ApiModelProperty("发券时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty("发券时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateEnd;

    @ApiModelProperty("核销时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime useTimeStart;

    @ApiModelProperty("核销时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime useTimeEnd;

    @ApiModelProperty("适用机场编号")
    private String airportNo;

    @ApiModelProperty("业态编号")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("是否排除转赠中的券：true-排除，false-不排除。默认不排除")
    private Boolean excludeGiveStatus;

    private int pageNum = 1;

    private int pageSize  = 10;

}
