package com.bizvane.members.feign.model.vo;

import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class CouponGoodsMerchantVO {

    @ApiModelProperty("商户")
    private TBasicMerchantVo merchantVo;

    @ApiModelProperty("商品集合")
    private List<CouponGoodsVO> couponGoodsVOList;

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class CouponGoodsVO {

        @ApiModelProperty("商品sku code")
        private String baseGoodsSkuCode;

        @ApiModelProperty("sku名称")
        private String skuName;

        @ApiModelProperty("sku编码")
        private String skuNo;
    }

}

