package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/member")
@Api("会员管理")
public interface MbrMemberFeign {

    @ApiOperation(value = "查询渠道和来源配置")
    @RequestMapping(value="/getChannelAndSourceConfig", method = RequestMethod.POST)
    ResponseData<List<MbrChannelAndSourceConfig>> getChannelAndSourceConfig();

    @ApiOperation(value = "查询会员列表")
    @RequestMapping(value="/list", method = RequestMethod.POST)
    ResponseData<PageInfo<MbrMembersVO>> list(@RequestBody MbrMemberListRequestParam param);

    @ApiOperation(value = "通过手机号查询会员")
    @RequestMapping(value="/getMemberByPhone", method = RequestMethod.POST)
    ResponseData<MbrMembersVO> getMemberByPhone(@RequestParam("phone") String phone);

    @ApiOperation(value = "通过unionId查询会员")
    @RequestMapping(value="/getMemberByUnionId", method = RequestMethod.POST)
    ResponseData<MbrMembersVO> getMemberByUnionId(@RequestParam("unionId") String unionId);

    @ApiOperation(value = "通过openId查询会员")
    @RequestMapping(value="/getMemberByOpenId", method = RequestMethod.POST)
    ResponseData<MbrMembersVO> getMemberByOpenId(@RequestParam("openId") String openId);

    @ApiOperation(value = "通过卡号查询会员")
    @RequestMapping(value="/getMemberByCardNo", method = RequestMethod.POST)
    ResponseData<MbrMembersVO> getMemberByCardNo(@RequestParam("cardNo") String cardNo);

    @ApiOperation(value = "查询会员详情")
    @RequestMapping(value="/detail", method = RequestMethod.POST)
    ResponseData<MbrMembersDetailVO> detail(@RequestParam("mbrMembersCode") String mbrMembersCode);

    @ApiOperation(value = "获取会员二维码")
    @RequestMapping(value="/getQRCode", method = RequestMethod.POST)
    ResponseData<MbrQRCodeRsp> getQRCode(@RequestParam("mbrMembersCode") String mbrMembersCode);

    @ApiOperation(value = "通过手机号或者unioinId查询会员")
    @RequestMapping(value="/getMemberByPhoneOrUnionId", method = RequestMethod.POST)
    ResponseData<MbrMembersVO> getMemberByPhoneOrUnionId(@RequestBody MbrMemberQueryRequestParam param);

    @ApiOperation(value = "开卡")
    @RequestMapping(value="/openCard", method = RequestMethod.POST)
    ResponseData<Boolean>  openCard(@RequestBody MbrOpenCardRequestParam param);

    @ApiOperation(value = "注销")
    @RequestMapping(value="/deregister", method = RequestMethod.POST)
    ResponseData<Boolean>  deregister(@RequestBody MbrMemberDeregisterRequestParam param);

    @ApiOperation(value = "更新会员资料")
    @RequestMapping(value="/update", method = RequestMethod.POST)
    ResponseData<Boolean> update(@RequestBody MbrMemberUpdateRequestParam updateRequestParam);

    @ApiOperation(value = "小程序端查询属性列表")
    @RequestMapping(value="/listPropertyApplet", method = RequestMethod.POST)
    ResponseData<MbrExtendPropertyAppletBO> listPropertyApplet(@RequestParam("mbrMembersCode") String mbrMembersCode);

    @ApiOperation(value = "小程序端更新属性")
    @RequestMapping(value="/updatePropertyApplet", method = RequestMethod.POST)
    ResponseData<Boolean> updatePropertyApplet(@RequestBody MbrExtendPropertyAppletBO bo);

    @ApiOperation(value = "更新会员资料-通过手机号")
    @RequestMapping(value="/updateByPhone", method = RequestMethod.POST)
    ResponseData<Boolean> updateByPhone(@RequestBody MbrMemberUpdateByPhoneRequest request);

    @ApiOperation(value = "实名认证")
    @RequestMapping(value="/realVerificationStatus", method = RequestMethod.POST)
    ResponseData<Boolean> realVerificationStatus(@RequestBody MbrMemberRealVerificationRequestParam param);

    @ApiOperation(value = "会员冻结/解冻接口")
    @RequestMapping(value="/frozenOrUnFrozen", method = RequestMethod.POST)
    ResponseData<Boolean> frozenOrUnFrozen(@RequestBody MbrMemberFrozenRequestParam param);

    @ApiOperation(value = "查询会员冻结/解冻记录列表")
    @RequestMapping(value="/listFrozenOrUnFrozenRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<MbrFrozenRecordVO>> listFrozenOrUnFrozenRecord(@RequestBody MbrFrozenRecordListRequestParam param);

    @ApiOperation(value = "查询会员消费信息")
    @RequestMapping(value="/getMbrConsume", method = RequestMethod.POST)
    ResponseData<MbrOrderConsumeVO> getMbrConsume(@RequestParam("mbrMembersCode") String mbrMembersCode);

    @ApiOperation(value = "查询达到下一个等级条件")
    @RequestMapping(value="/getNextLevelCondition", method = RequestMethod.POST)
    ResponseData<MbrLevelDefVO> getNextLevelCondition(@RequestParam("mbrMembersCode") String mbrMembersCode, @RequestParam("mbrLevelDefCode") String mbrLevelDefCode);

}
