package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Data
public class MbrIntegralRuleListRequestParam {

    // 组织code集合
    private List<String> orgCodeList;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型：1-业态，2-商户，3-特殊")
    private Integer scopeType;

    @ApiModelProperty("状态：0-禁用，1-启用， 2-过期")
    private Integer status;

    private int pageNum = 1;

    private int pageSize  = 10;
}