package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MbrFlightRecordAddReq {

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("消息类型")
    private String messageType;

    @ApiModelProperty("数据源站点")
    private String station;

    @ApiModelProperty("旅客离港信息 ID，兼容离港或者虹桥格式")
    private String dcsPsgId;

    @ApiModelProperty("英文姓名(旅客英文姓名可能为空)")
    private String nameEn;

    @ApiModelProperty("中文姓名(旅客中文姓名可能为空)")
    private String nameCn;

    @ApiModelProperty("旅客证件类型")
    private String certificateType;

    @ApiModelProperty("证件号，证件类型+证件号码，其中：NI-身份证，PP-护照，ID-其他证件。如果格式是 PP，其格式为：编号/国籍/生日/性别/其他，如：PP086812931/US/12JUN48//NI310652198002026857")
    private String certificateId;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("国籍")
    private String nation;

    @ApiModelProperty("航班日期")
    private String flightDate;

    @ApiModelProperty("航班日期时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime flightDatetime;

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty("共享航班号")
    private String slaveFlight;

    @ApiModelProperty("国内(D),国际(ID,1),地区(R),混合(M)")
    private String flightCountryType;

    @ApiModelProperty("始发站(IATA)")
    private String originAirport;

    @ApiModelProperty("始发站中文")
    private String originAirportZh;

    @ApiModelProperty("旅客目的站(IATA)")
    private String destinationAirport;

    @ApiModelProperty("旅客目的站(中文)")
    private String destinationAirportZh;

    @ApiModelProperty("登机序号")
    private Integer boardNo;

    @ApiModelProperty("座位号")
    private String seatNo;

    @ApiModelProperty("旅客主舱位信息")
    private String class1;

    @ApiModelProperty("旅客联系信息(转自离港系统,部分旅客包含手机号)")
    private String contactInfo;

    @ApiModelProperty("婴儿信息")
    private String babyInfo;

    @ApiModelProperty("中转旅客标识")
    private String isTransit;

    @ApiModelProperty("重点旅客标识")
    private String isVip;

    @ApiModelProperty("常旅客信息(兼容 DCS 格式)")
    private String fffr;

    @ApiModelProperty("团体旅客标识")
    private String group;

    @ApiModelProperty("行李总件数")
    private Integer bags;

    @ApiModelProperty("行李总重量(Kg)")
    private BigDecimal bagsWeight;

    @ApiModelProperty("航站楼")
    private String terminal;

    @ApiModelProperty("值机状态")
    private String checkInStatus;

    @ApiModelProperty("值机柜台，值机柜台号，由离港接口协议根据打印机编号转换")
    private String counterNo;

    @ApiModelProperty("旅客值机时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime checkInTime;

    @ApiModelProperty("所有登机口 (机场定义的登机口名称，自由文本，不超过 20 字符)")
    private String gates;

    @ApiModelProperty("登机状态")
    private String boardStatus;

    @ApiModelProperty("旅客登机时间")
    private LocalDateTime boardingTime;

    @ApiModelProperty("执行旅客登机操作的终端号，登机口号")
    private String boardPid;

    @ApiModelProperty("登机通道")
    private String boardMethod;

    @ApiModelProperty("登机方式")
    private String boardWay;

    @ApiModelProperty("拉下原因")
    private String unbrdReason;
}
