package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员积分使用记录
 * </p>
 *
 * @author Trump
 * @since 2024-09-26
 */
@Data
public class MbrIntegralRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("流水code")
    private String mbrIntegralRecordCode;

    @ApiModelProperty("变更单据")
    private String changeBills;

    @ApiModelProperty("变更来源")
    private String changeSource;

    @ApiModelProperty("变更积分")
    private Integer changeIntegral;

    @ApiModelProperty("可用积分")
    private Integer availableIntegral;

    @ApiModelProperty("已使用积分")
    private Integer usedIntegral;

    @ApiModelProperty("过期积分")
    private Integer expiredIntegral;

    @ApiModelProperty("积分过期时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime expiredTime;

    @ApiModelProperty("变动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime changeDate;

    @ApiModelProperty("变动类型1.支出,2.收入,3过期")
    private Integer changeWay;

    @ApiModelProperty("变更详情")
    private String changeDetails;

    @ApiModelProperty("业务类型：枚举IntegralBusinessWayEnum，字典integral_business_way")
    private Integer businessWay;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private Long modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime modifiedDate;

}
