package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class MbrIntegralRegistrationReviewRequestParam {

    @ApiModelProperty("积分登记code")
    @NotBlank
    private String mbrIntegralRegistrationCode;

    @ApiModelProperty("状态：1-通过，2-不通过")
    @NotNull
    private Integer status;

    @ApiModelProperty("赠送积分")
    @NotNull
    private Integer giveIntegral;

    @ApiModelProperty("积分有效期天数")
    @NotNull
    private Integer integralValidDay;

    @ApiModelProperty("审核说明")
    private String info;

    @ApiModelProperty("审核人code")
    @NotBlank
    private String userCode;

    @ApiModelProperty("审核人姓名")
    private String userName;
}