package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
public class CouponTransferRequestParam {

    @NotEmpty
    @ApiModelProperty("券号")
    private String couponNo;

    @NotEmpty
    @ApiModelProperty("转增人code")
    private String transferMemberCode;

    @NotNull
    @ApiModelProperty("业务时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime businessTime;

}
