package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrFlightRecordFocusReq2 {

    @NotBlank(message = "会员code不能为空")
    @ApiModelProperty(value = "会员表code", example = "mbrMembersCode100", required = true)
    private String mbrMembersCode;

    @ApiModelProperty("关注来源：1-总线，2-小程序，3-外部小程序")
    private Integer focusSource;

    @ApiModelProperty(value = "关注人身份：1.乘机人，2.接机人，3.送机人", example = "1", required = true)
    @NotNull(message = "关注人身份不能为空")
    private Integer focusType;

    @ApiModelProperty("关注状态：1.关注、2.取消关注")
    private Integer focusStatus;

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty(value = "航班日期（格式：yyyy-MM-dd）", example = "2024-12-01", required = true)
    private String flightDate;

    @ApiModelProperty(value = "始发机场 IATA", example = "HAK", required = true)
    @NotBlank(message = "始发机场不能为空")
    private String originAirport;

    @ApiModelProperty(value = "目的机场 IATA", example = "NGB", required = true)
    @NotBlank(message = "目的机场不能为空")
    private String destinationAirport;

    @ApiModelProperty("中转旅客标识：1-中转，2-非中转")
    private String isTransit;

    @ApiModelProperty("中转航班号")
    private String transitFlightIdentity;

    @ApiModelProperty("中转航班日期（格式：yyyy-MM-dd）")
    private String transitFlightDate;

    @ApiModelProperty("中转始发机场 IATA")
    private String transitOriginAirport;

    @ApiModelProperty("中转目的机场 IATA")
    private String transitDestinationAirport;
}
