package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrAddressAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrAddressUpdateRequestParam;
import com.bizvane.members.feign.model.bo.MbrExtendDefDeleteRequestParam;
import com.bizvane.members.feign.model.vo.MbrAddressVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrAddress")
@Api("会员地址管理")
public interface MbrAddressFeign {

  @ApiOperation(value = "新增地址")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody MbrAddressAddRequestParam param);

  @ApiOperation(value = "列表查询")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<List<MbrAddressVO>> list(@RequestParam("mbrMembersCode") String mbrMembersCode);

  @ApiOperation(value = "详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<MbrAddressVO> detail(@RequestParam("mbrAddressCode") String mbrAddressCode);

  @ApiOperation(value = "更新")
  @RequestMapping(value="/update", method = RequestMethod.POST)
  ResponseData<Boolean> update(@RequestBody MbrAddressUpdateRequestParam param);

  @ApiOperation(value = "删除")
  @RequestMapping(value="/delete", method = RequestMethod.POST)
  ResponseData<Boolean> delete(@RequestParam("mbrAddressCode") String mbrAddressCode);

}