package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrExtendDefAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrExtendDefDeleteRequestParam;
import com.bizvane.members.feign.model.bo.MbrExtendDefListRequestParam;
import com.bizvane.members.feign.model.bo.MbrExtendDefUpdateRequestParam;
import com.bizvane.members.feign.model.vo.MbrExtendDefVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrExtend")
@Api("会员扩展属性")
public interface MbrExtendFeign {

  @ApiOperation(value = "新增属性定义")
  @RequestMapping(value="/addDef", method = RequestMethod.POST)
  ResponseData<String> addDef(@RequestBody MbrExtendDefAddRequestParam param);

  @ApiOperation(value = "更新属性定义")
  @RequestMapping(value="/updateDef", method = RequestMethod.POST)
  ResponseData<Boolean> updateDef(@RequestBody MbrExtendDefUpdateRequestParam param);

  @ApiOperation(value = "列表查询")
  @RequestMapping(value="/listDef", method = RequestMethod.POST)
  PageInfo<MbrExtendDefVO> listDef(@RequestBody MbrExtendDefListRequestParam param);

  @ApiOperation(value = "属性定义详情")
  @RequestMapping(value="/detailDef", method = RequestMethod.POST)
  MbrExtendDefVO detailDef(@RequestParam("mbrExtendDefCode") String mbrExtendDefCode);

  @ApiOperation(value = "删除属性定义")
  @RequestMapping(value="/deleteDef", method = RequestMethod.POST)
  ResponseData<Boolean> deleteDef(@RequestBody MbrExtendDefDeleteRequestParam param);

}