package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员属性定义
 * </p>
 *
 * @author Trump
 * @since 2024-09-13
 */
@Data
public class MbrExtendDefVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("code")
    private String mbrExtendDefCode;

    @ApiModelProperty("属性code")
    private String propertyCode;

    @ApiModelProperty("属性名称")
    private String propertyName;

    @ApiModelProperty("属性类型(1.单选,2.多选,3.时间,4.数字,5.文本)")
    private Integer propertyType;

    @ApiModelProperty("属性选项")
    private String propertyOption;

    @ApiModelProperty("是否可见:1可见,0不可见")
    private Boolean visible;

    @ApiModelProperty("微信小程序端是否可见:1可见,0不可见")
    private Boolean wxVisible;

    @ApiModelProperty("是否允许编辑,1不可编辑,2可编辑")
    private Boolean edit;

    @ApiModelProperty("是否必填1必传,0非必传")
    private Boolean required;

    @ApiModelProperty("属性备注")
    private String detail;

    @ApiModelProperty("排序规则")
    private Integer sorted;

    @ApiModelProperty("定义类型：1基础信息；2拓展信息")
    private Integer defType;

    @ApiModelProperty("属性状态：1启用 0禁用")
    private Boolean status;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime modifiedDate;
}
