package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 等级定义表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrBenefitsDetailAppletVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员权益code")
    private String mbrBenefitsCode;

    @ApiModelProperty("权益名称")
    private String name;

    @ApiModelProperty("权益描述")
    private String detail;

    @ApiModelProperty("图标URL")
    private String iconUrl;

    @ApiModelProperty("权益图片URL")
    private String imageUrl;

    @ApiModelProperty("权益卡片url")
    private String cardUrl;

    @ApiModelProperty("权益说明")
    private String description;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("是否开启：1-开启，0-关闭")
    private Boolean status;

    @ApiModelProperty("权益领取方式：1-权益领取，2-链接跳转")
    private Integer claimMethod;

    @ApiModelProperty("权益类型：1-优惠券，2-积分")
    private Integer type;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("获取规则限制类型：1-日，2-周，3-月，4-年")
    private Integer limitType;

    @ApiModelProperty("获取规则限制次数")
    private Integer limitCount;

    @ApiModelProperty("链接类型：1-内部小程序，2-第三方小程序，3-H5")
    private Integer linkType;

    @ApiModelProperty("链接小程序appid，内部小程序为空")
    private String linkAppid;

    @ApiModelProperty("链接小程序名称，内部小程序为空")
    private String linkAppname;

    @ApiModelProperty("链接路径")
    private String linkUrl;

    @ApiModelProperty("链接路径名称")
    private String linkName;

}
