package com.bizvane.members.feign.model.vo;

import com.bizvane.members.feign.model.bo.MbrExtendMembersPropertyUpdateRequestParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 会员卡表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrMembersDetailVO implements Serializable {

    @ApiModelProperty("会员表code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("会员性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("手机号脱敏")
    private String phone;

    @ApiModelProperty("手机号加密")
    private String phoneEncrypt;

    @ApiModelProperty("微信unioinid")
    private String unionId;

    @ApiModelProperty("微信openId")
    private String openId;

    @ApiModelProperty("会员邮箱")
    private String email;

    @ApiModelProperty("身份证")
    private String idCard;

    @ApiModelProperty("会员生日")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime birthday;

    @ApiModelProperty("会员省份")
    private String province;

    @ApiModelProperty("会员市区")
    private String city;

    @ApiModelProperty("会员县")
    private String county;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("会员头像")
    private String headPortraits;

    @ApiModelProperty("会员卡条形码")
    private String barCode;

    @ApiModelProperty("类型,1:冻结 2: 解冻")
    private Integer cardStatus;

    @ApiModelProperty("1-黑名单，2-白名单")
    private Integer statusFlag;

    @ApiModelProperty("会员类型：0-普通会员，1-内部员工、2-委外员工")
    private Integer type;

    @ApiModelProperty("开卡时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openCardTime;

    @ApiModelProperty("会员等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("会员等级名称")
    private String mbrLevelDefName;

    @ApiModelProperty("会员积分")
    private Integer countIntegral;

    @ApiModelProperty("注册渠道")
    private String channelCode;

    @ApiModelProperty("注册来源")
    private String sourceCode;

    @ApiModelProperty("注册机场code")
    private String airportCode;

    @ApiModelProperty("注册详情类型：1-楼宇，2-商户，3-渠道码")
    private Integer detailType;

    @ApiModelProperty("注册详情code")
    private String detailCode;

    @ApiModelProperty("是否已实名认证：false-未实名，true-已实名")
    private Boolean realVerificationStatus;

    @ApiModelProperty("身份证姓名")
    private String idCardName;

    @ApiModelProperty("身份证号")
    private String idCardNumber;

    @ApiModelProperty("会员扩展属性")
    private List<MbrExtendMembersPropertyUpdateRequestParam> extendPropertyList;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;


}
