package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 外部券汇总表
 * </p>
 *
 * @author Trump
 * @since 2024-09-24
 */
@Data
public class CouponExternalSumVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("外部券汇总表code")
    private String couponExternalSumCode;

    @ApiModelProperty("券定义code")
    private String couponDefinitionCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("外部系统券编码")
    private String externalSystemCouponCode;

    @ApiModelProperty("券所属机场编号")
    private String airportNoOrg;

    @ApiModelProperty("同步数量")
    private Integer couponCount;

    @ApiModelProperty("剩余可用数量")
    private Integer remainingCount;

    @ApiModelProperty("优惠类型（1现金，2折扣，3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("状态：25-导入中，30-导入完成，35-停用")
    private Integer status;

    @ApiModelProperty("导入方式：1-后台导入，2-接口导入")
    private Integer importType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;
}
