package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员积分特殊规则
 * </p>
 *
 * @author Trump
 * @since 2024-10-14
 */
@Data
public class MbrIntegralRuleVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("积分规则code")
    private String mbrIntegralRuleCode;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("有效期类型:0-永久有效，1-指定时间")
    private Integer validType;

    @ApiModelProperty("有效期开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("规则类型：1-业态，2-商户，3-特殊")
    private Integer scopeType;

    @ApiModelProperty("适用机场编号")
    private String scopeAirportNoList;

    @ApiModelProperty("业态编号")
    private String scopeMerchantNoList;

    @ApiModelProperty("商户编号")
    private String scopeIndustryNoList;

    @ApiModelProperty("会员条件类型：0-全部会员，1-分组")
    private Integer mbrConditionType;

    @ApiModelProperty("分组code")
    private String mbrGroupDefCode;

    @ApiModelProperty("分组名")
    private String groupName;

    @ApiModelProperty("规则类型:0-不获取积分，1-获取积分")
    private Integer ruleType;

    @ApiModelProperty("金额")
    private Integer money;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("策略：1-四舍五入，2-向下取整，3-向上取整")
    private Integer strategy;

    @ApiModelProperty("折扣限制:0-无限制，1-限制")
    private Integer discountLimit;

    @ApiModelProperty("最低折扣")
    private BigDecimal discountMin;

    @ApiModelProperty("最高折扣")
    private BigDecimal discountMax;

    @ApiModelProperty("积分有效期天数")
    private Integer integralValidDay;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态：1-启用，0-禁用")
    private Boolean status;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime modifiedDate;

}
