package com.bizvane.members.feign.model.mq;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrOrderAddMQ {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty(value = "订单系统编号")
    private String orderCode;

    @ApiModelProperty("订单标志：1-订单，2-退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("订单状态：1-待付款, 2-待发货, 3-已发货, 4-已签收, 5-交易成功, 6-退款中, 7-退款成功, 8-交易关闭")
    private Integer orderStatus;

    @ApiModelProperty("订单金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty("商品数量")
    private Integer productCount;

    @ApiModelProperty("下单时间")
    private LocalDateTime placeOrderTime;

    @ApiModelProperty("支付时间 ")
    private LocalDateTime payTime;

    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty(value = "订单折扣")
    private BigDecimal discount;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("是否首单：true首单")
    private boolean isFirst;

    @ApiModelProperty(value = "消费渠道")
    private String channelCode;

    @ApiModelProperty(value = "消费来源")
    private String sourceCode;
}
