package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
@Data
public class MbrBenefitsVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员权益code")
    private String mbrBenefitsCode;

    @ApiModelProperty("权益名称")
    private String name;

    @ApiModelProperty("权益描述")
    private String detail;

    @ApiModelProperty("权益图片URL")
    private String imageUrl;

    @ApiModelProperty("权益说明")
    private String description;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;
}
