package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrChannelAndSourceConfig {

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("渠道名")
    private String channelName;

    private List<MbrChannelAndSourceConfigSub> courceList = new ArrayList<>();

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class MbrChannelAndSourceConfigSub {

        @ApiModelProperty("来源code")
        private String sourceCode;

        @ApiModelProperty("来源名")
        private String sourceName;
    }
}
