package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class MbrIntegralSubRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("变更单据")
    private String changeBills;

    @ApiModelProperty("变更来源")
    private String changeSource;

    @ApiModelProperty("变更积分")
    private Integer changeIntegral;

    @ApiModelProperty("变动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDate;

    @ApiModelProperty("变更详情")
    private String changeDetails;

    @ApiModelProperty("积分业务类型：枚举类IntegralBusinessWayEnum")
    private Integer businessWay;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("修改人code")
    private String userCode;

    @ApiModelProperty("修改人")
    private String userName;

}
