package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrLifecycleParameterSaveRequestParam;
import com.bizvane.members.feign.model.vo.MbrLifecycleParameterVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrConfig")
@Api("会员配置")
public interface MbrConfigFeign {

    @ApiOperation(value = "查询")
    @RequestMapping(value="/detail", method = RequestMethod.POST)
    ResponseData<MbrLifecycleParameterVO> detail();

    @ApiOperation(value = "保存")
    @RequestMapping(value="/save", method = RequestMethod.POST)
    ResponseData<Boolean> save(@RequestBody MbrLifecycleParameterSaveRequestParam param);
}
