package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MbrIntegralGeneralRuleAddBO {

    @ApiModelProperty("规则类型:0-不获取积分，1-获取积分")
    private Integer ruleType;

    @ApiModelProperty("金额")
    private Integer money;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("策略：1-四舍五入，2-向下取整，3-向上取整")
    private Integer strategy;

    @ApiModelProperty("折扣限制:0-无限制，1-限制")
    private Integer discountLimit;

    @ApiModelProperty("最低折扣")
    private BigDecimal discountMin;

    @ApiModelProperty("最高折扣")
    private BigDecimal discountMax;

    @ApiModelProperty("积分有效期天数")
    private Integer integralValidDay;

    @ApiModelProperty("详细说明")
    private String info;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;
}