package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 等级定义表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrLevelDefVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("等级编号")
    private String levelNo;

    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("等级排序值")
    private Integer levelValue;

    @ApiModelProperty("卡背景URL")
    private String cardBackUrl;

    @ApiModelProperty("文案颜色")
    private String wordColor;

    @ApiModelProperty("升降级规则开启状态：1-开启；0-关闭")
    private Boolean ruleStatus;

    @ApiModelProperty("升级累计消费开关：true-开启，false-关闭")
    private Boolean upTotalConsumerStatus;

    @ApiModelProperty("升级累计消费月数")
    private Integer upTotalConsumerMonthNum;

    @ApiModelProperty("升级累计消费金额")
    private Integer upTotalConsumerAmount;

    @ApiModelProperty("升级累计飞行开关：true-开启，false-关闭")
    private Boolean upTotalFlightStatus;

    @ApiModelProperty("升级累计飞行月数")
    private Integer upTotalFlightMonthNum;

    @ApiModelProperty("升级累计飞行次数")
    private Integer upTotalFlightNumber;

    @ApiModelProperty("升级累计条件关系：true-且，false-或")
    private Boolean upTotalIsAnd;

    @ApiModelProperty("升级单笔消费开关：true-开启，false-关闭")
    private Boolean upSingleConsumerStatus;

    @ApiModelProperty("升级单笔消费金额")
    private Integer upSingleConsumerAmount;

    @ApiModelProperty("降级累计消费开关：true-开启，false-关闭")
    private Boolean downTotalConsumerStatus;

    @ApiModelProperty("降级累计消费月数")
    private Integer downTotalConsumerMonthNum;

    @ApiModelProperty("降级累计消费金额")
    private Integer downTotalConsumerAmount;

    @ApiModelProperty("降级累计飞行开关：true-开启，false-关闭")
    private Boolean downTotalFlightStatus;

    @ApiModelProperty("降级累计飞行月数")
    private Integer downTotalFlightMonthNum;

    @ApiModelProperty("降级累计飞行次数")
    private Integer downTotalFlightNumber;

    @ApiModelProperty("降级累计条件关系：true-且，false-或")
    private Boolean downTotalIsAnd;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

}
