package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class OrderListRequestParam {

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("会员code")
    private String mbrMemberCode;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime placeOrderStart;

    @ApiModelProperty("时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime placeOrderEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
