package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrBenefits")
@Api("会员权益管理")
public interface MbrBenefitsFeign {

  @ApiOperation(value = "权益列表")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<MbrBenefitsDetailVO>> list(MbrBenefitsListRequestParam param);

  @ApiOperation(value = "权益详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<MbrBenefitsDetailVO> detail(@RequestParam("mbrBenefitsCode") @NotNull String mbrBenefitsCode);

  @ApiOperation(value = "新增")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody MbrBenefitsAddRequestParam param);

  @ApiOperation(value = "删除")
  @RequestMapping(value="/delete", method = RequestMethod.POST)
  ResponseData<Boolean> delete(@RequestParam("mbrBenefitsCode") @NotNull String mbrBenefitsCode);

  @ApiOperation(value = "修改")
  @RequestMapping(value="/update", method = RequestMethod.POST)
  ResponseData<Boolean> update(@RequestBody MbrBenefitsUpdateRequestParam param);

  @ApiOperation(value = "通过等级code查询权益")
  @RequestMapping(value="/listByLevel", method = RequestMethod.POST)
  ResponseData<List<MbrBenefitsVO>> listByLevel(@RequestParam("mbrLevelDefCode") @NotNull String mbrLevelDefCode);

  @ApiOperation(value = "检查会员是否参与过指定权益指定等级")
  @RequestMapping(value="/checkIsParticipate", method = RequestMethod.POST)
  ResponseData<Boolean> checkIsParticipate(@RequestBody MbrBenefitsCheckIsParticipateRequestParam param);

  @ApiOperation(value = "领取权益")
  @RequestMapping(value="/receive", method = RequestMethod.POST)
  ResponseData<String> receive(@RequestBody MbrBenefitsCheckIsParticipateRequestParam param);

}
