package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class FlightRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("航班记录code")
    private String mbrFlightRecordCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("航空公司编号")
    private String airlinesCode;

    @ApiModelProperty("航班号")
    private String flightNo;

    @ApiModelProperty("客票号")
    private String ticketNumber;

    @ApiModelProperty("客票类型：1-成人票，2-儿童票")
    private Integer ticketType;

    @ApiModelProperty("座位号")
    private String seatNumber;

    @ApiModelProperty("出发机场")
    private String departureAirport;

    @ApiModelProperty("到达机场")
    private String arrivalAirport;

    @ApiModelProperty("出发时间")
    private LocalDateTime departureDate;

    @ApiModelProperty("到达时间")
    private LocalDateTime arrivalDate;

    @ApiModelProperty("机票价格")
    private BigDecimal ticketPrice;

    @ApiModelProperty("预定时间")
    private LocalDateTime bookingDate;

    @ApiModelProperty("机型")
    private String aircraftType;

    @ApiModelProperty("行李处理方式：1-未托运，2-已托运")
    private Integer baggageMethods;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime modifiedDate;

}
