package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员积分登记表
 * </p>
 *
 * @author Trump
 * @since 2024-10-30
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class MbrIntegralRegistrationVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("积分登记code")
    private String mbrIntegralRegistrationCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("赠送积分")
    private Integer giveIntegral;

    @ApiModelProperty("积分有效期天数")
    private Integer integralValidDay;

    @ApiModelProperty("审核说明")
    private String info;

    @ApiModelProperty("状态：0-待审核，1-通过，2-不通过")
    private Integer status;

    @ApiModelProperty("审核时间")
    private LocalDateTime reviewDate;

    @ApiModelProperty("匹配积分规则code")
    private String mbrIntegralRuleCode;

    @ApiModelProperty("匹配积分规则名")
    private String mbrIntegralRuleName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;
}
