package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.members.feign.model.vo.CouponTransferLogVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/coupon")
@Api("券实例管理")
public interface CouponFeign {

  @ApiOperation(value = "发券")
  @RequestMapping(value="/send", method = RequestMethod.POST)
  ResponseData<List<CouponEntityListResponseParam>> send(@RequestBody CouponEntityAddRequestParam param);

  @ApiOperation(value = "核销")
  @RequestMapping(value="/use", method = RequestMethod.POST)
  ResponseData<Boolean> use(@RequestBody CouponEntityUseRequestParam param);

  @ApiOperation(value = "撤销核销")
  @RequestMapping(value="/revert", method = RequestMethod.POST)
  ResponseData<Boolean> revert(@RequestBody CouponEntityRevertRequestParam param);

  @ApiOperation(value = "列表查询")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<CouponEntityListResponseParam>> list(@RequestBody CouponEntityListRequestParam param);

  @ApiOperation(value = "失败券列表查询")
  @RequestMapping(value="/listFail", method = RequestMethod.POST)
  ResponseData<PageInfo<CouponEntityListResponseParam>> listFail(@RequestBody CouponEntityListRequestParam param);

  @ApiOperation(value = "通过券号查询券详情")
  @RequestMapping(value="/detailByCouponNo", method = RequestMethod.POST)
  ResponseData<CouponEntityListResponseParam> detailByCouponNo(@RequestParam("couponNo") String couponNo);

  @ApiOperation(value = "通过券code查询券详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<CouponEntityListResponseParam> detail(@RequestParam("couponEntityCode") String couponEntityCode);

  @ApiOperation(value = "券转赠发起")
  @RequestMapping(value="/transfer", method = RequestMethod.POST)
  ResponseData<Boolean> transfer(@RequestBody CouponTransferRequestParam param);

  @ApiOperation(value = "转增撤回")
  @RequestMapping(value="/transferRevert", method = RequestMethod.POST)
  ResponseData<Boolean> transferRevert(@RequestParam("couponEntityCode") String couponEntityCode);

  @ApiOperation(value = "券受赠")
  @RequestMapping(value="/give", method = RequestMethod.POST)
  ResponseData<Boolean> give(@RequestBody CouponGiveRequestParam param);

  @ApiOperation(value = "券转赠列表")
  @RequestMapping(value="/listTransfer", method = RequestMethod.POST)
  ResponseData<PageInfo<CouponTransferLogVO>> listTransfer(@RequestBody CouponTransferLogListRequestParam param);
}