package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MbrFlightRecordAddRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("航空公司编号")
    private String airlinesCode;

    @ApiModelProperty("航班号")
    private String flightNo;

    @ApiModelProperty("客票号")
    private String ticketNumber;

    @ApiModelProperty("客票类型：1-成人票，2-儿童票")
    private Integer ticketType;

    @ApiModelProperty("座位号")
    private String seatNumber;

    @ApiModelProperty("出发机场")
    private String departureAirport;

    @ApiModelProperty("到达机场")
    private String arrivalAirport;

    @ApiModelProperty("出发时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime departureDate;

    @ApiModelProperty("到达时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime arrivalDate;

    @ApiModelProperty("机票价格")
    private BigDecimal ticketPrice;

    @ApiModelProperty("预定时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime bookingDate;

    @ApiModelProperty("机型")
    private String aircraftType;

    @ApiModelProperty("行李处理方式：1-未托运，2-已托运")
    private Integer baggageMethods;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;
}
