package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
@Builder
@Data
public class OrderBO {

    @ApiModelProperty("会员code")
    private String mbrMemberCode;

    @NotBlank
    @ApiModelProperty("订单号")
    private String orderNo;

    @NotNull
    @ApiModelProperty("订单标志：1-订单，2-退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("订单状态：1-待付款, 2-待发货, 3-已发货, 4-已签收, 5-交易成功, 6-退款中, 7-退款成功, 8-交易关闭")
    private String orderStatus;

    @NotNull
    @ApiModelProperty("折扣价 * 数量")
    private BigDecimal tradeAmount;

    @NotNull
    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime placeOrderTime;

    @NotNull
    @ApiModelProperty("支付时间 ")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime payTime;

    @NotNull
    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @NotBlank
    @ApiModelProperty("机场编号")
    private String airportNo;

    @NotBlank
    @ApiModelProperty("行业")
    private String industryNo;

    @NotBlank
    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

    @NotEmpty
    private List<OrderDetailBO> orderDetailList;

    private List<OrderPaymentBO> orderPaymentList;
}
