package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.CouponExternalRecordAddRequestParam;
import com.bizvane.members.feign.model.bo.CouponExternalSumRequestParam;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/couponExternal")
@Api("外部券管理")
public interface CouponExternalFeign {

  @ApiOperation(value = "新增外部券汇总")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody CouponExternalSumRequestParam param);

  @ApiOperation(value = "新增外部券明细")
  @RequestMapping(value="/addRecord", method = RequestMethod.POST)
  ResponseData<String> addRecord(@RequestBody CouponExternalRecordAddRequestParam param);
}