package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MbrIntegralRuleUpdateRequestParam {

    @ApiModelProperty("积分规则code")
    @NotBlank
    private String mbrIntegralRuleCode;

    @ApiModelProperty("规则名称")
    @NotBlank
    private String ruleName;

    @ApiModelProperty("有效期类型:0-永久有效，1-指定时间")
    @NotNull
    private Integer validType;

    @ApiModelProperty("有效期开始时间")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("规则类型：1-业态，2-商户，3-特殊")
    private Integer scopeType;

    @ApiModelProperty("适用机场编号")
    private String scopeAirportNoList;

    @ApiModelProperty("业态编号")
    private String scopeMerchantNoList;

    @ApiModelProperty("商户编号")
    private String scopeIndustryNoList;

    @ApiModelProperty("会员条件类型：0-全部会员，1-分组")
    private Integer mbrConditionType;

    @ApiModelProperty("分组code")
    private String mbrGroupDefCode;

    @ApiModelProperty("规则类型:0-不获取积分，1-获取积分")
    private Integer ruleType;

    @ApiModelProperty("金额")
    private Integer money;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("策略：1-四舍五入，2-向下取整，3-向上取整")
    private Integer strategy;

    @ApiModelProperty("折扣限制:0-无限制，1-限制")
    private Integer discountLimit;

    @ApiModelProperty("最低折扣")
    private BigDecimal discountMin;

    @ApiModelProperty("最高折扣")
    private BigDecimal discountMax;

    @ApiModelProperty("积分有效期天数")
    private Integer integralValidDay;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;
}