package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class CouponDefinitionListRequestParam {

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券状态（1已启用，0已停用）")
    private Boolean status;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("创建人")
    private String userName;

    @ApiModelProperty("创建时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty("创建时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;

}
