package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class CouponManualAddRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("任务名称")
    @NotBlank
    private String taskName;

    @ApiModelProperty("券类型：\"110预生成券\"，空值标准券")
    @NotNull
    private Integer couponType;

    @ApiModelProperty("会员查询条件类型: 0-全部会员;1-筛选会员;2-会员分组")
    private Integer memberConditionType;

    @ApiModelProperty("会员查询条件")
    private String memberCondition;

    @ApiModelProperty("发券人数（预生成券）")
    private Integer memberCount;

    @ApiModelProperty("券集合")
    private List<CouponManualCouponDefBO> couponList;

    @ApiModelProperty("发送类型：1-立即发送，2-指定时间")
    private Integer sendType;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class CouponManualCouponDefBO {
        @ApiModelProperty("券定义code")
        private String couponDefinitionCode;

        @ApiModelProperty("券定义名称")
        private String couponDefinitionName;
    }
}
