package com.bizvane.members.feign.model.vo;

import com.bizvane.members.feign.model.bo.CouponManualAddRequestParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CouponManualVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("手工发券code")
    private String couponManualCode;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("券集合")
    private List<CouponManualAddRequestParam.CouponManualCouponDefBO> couponList;

    @ApiModelProperty("发券人数")
    private Integer memberCount;

    @ApiModelProperty("发券成功数量")
    private Integer successCount;

    @ApiModelProperty("失败数量")
    private Integer failCount;

    @ApiModelProperty("核销数量")
    private Integer useCount;

    @ApiModelProperty("发送类型：1-立即发送，2-指定时间")
    private Integer sendType;

    @ApiModelProperty("发券时间")
    private LocalDateTime sendTime;

    @ApiModelProperty("任务状态：5-新建，10-待审核，15-待执行，20-审核不通过，25-发送中，30-发送完成，35-部分失败，40-已作废，45-同步中")
    private Integer taskStatus;

    @ApiModelProperty("审核人id")
    private Long reviewUserId;

    @ApiModelProperty("审核人名字")
    private String reviewUserName;

    @ApiModelProperty("会员查询条件")
    private String memberCondition;

    @ApiModelProperty("会员查询条件类型: 0-全部会员;1-筛选会员;2-会员分组")
    private Integer memberConditionType;

    @ApiModelProperty("券类型：\"110预生成券\"，空值标准券")
    private Integer couponType;

    @ApiModelProperty("MQ发券状态：0-停止，1-发送中，2-已完成")
    private Integer mqState;

    @ApiModelProperty("mq发送券定义json")
    private String mqCouponJson;

    @ApiModelProperty("mq发送会员id")
    private Long mqMbrMemberId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;
}
