package com.bizvane.members.feign.model.vo;

import com.bizvane.members.feign.model.bo.MbrExtendMembersPropertyUpdateRequestParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 会员卡表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrMembersDetailVO implements Serializable {

    @ApiModelProperty("会员表code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("会员性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("手机号脱敏")
    private String phoneEncrypt;

    @ApiModelProperty("会员邮箱")
    private String email;

    @ApiModelProperty("身份证")
    private String idCard;

    @ApiModelProperty("会员生日")
    private LocalDateTime birthday;

    @ApiModelProperty("会员省份")
    private String province;

    @ApiModelProperty("会员市区")
    private String city;

    @ApiModelProperty("会员县")
    private String county;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("会员头像")
    private String headPortraits;

    @ApiModelProperty("会员卡条形码")
    private String barCode;

    @ApiModelProperty("会员卡状态0：冻结, 1.正常")
    private Integer cardStatus;

    @ApiModelProperty("1-黑名单，2-白名单")
    private Integer statusFlag;

    @ApiModelProperty("会员体系编码")
    private String memberSysId;

    @ApiModelProperty("开卡时间")
    private LocalDateTime openCardTime;

    @ApiModelProperty("会员等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("拓展字段值id")
    private String extendIds;

    @ApiModelProperty("会员积分")
    private Integer countIntegral;

    @ApiModelProperty("会员扩展属性")
    private List<MbrExtendMembersPropertyUpdateRequestParam> extendPropertyList;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;


}
