package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.members.feign.model.vo.MbrLabelDefVO;
import com.bizvane.members.feign.model.vo.MbrLabelTypeDefVO;
import com.bizvane.members.feign.model.vo.MbrMemberLabelVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrLabel")
@Api("会员标签")
public interface MbrLabelFeign {

  @ApiOperation(value = "查询标签组列表")
  @RequestMapping(value="/listTypeDef", method = RequestMethod.POST)
  ResponseData<List<MbrLabelTypeDefVO>> listTypeDef();

  @ApiOperation(value = "新增标签组")
  @RequestMapping(value="/addTypeDef", method = RequestMethod.POST)
  ResponseData<String> addTypeDef(@RequestBody MbrLabelTypeDefAddRequestParam param);

  @ApiOperation(value = "删除标签组")
  @RequestMapping(value="/deleteTypeDef", method = RequestMethod.POST)
  ResponseData<Boolean> deleteTypeDef(@RequestParam("mbrLabelTypeDefCode") String mbrLabelTypeDefCode);

  @ApiOperation(value = "更新标签组")
  @RequestMapping(value="/updateTypeDef", method = RequestMethod.POST)
  ResponseData<Boolean> updateTypeDef(@RequestBody MbrLabelTypeDefUpdateRequestParam param);

  @ApiOperation(value = "移动标签组")
  @RequestMapping(value="/moveTypeDef", method = RequestMethod.POST)
  ResponseData<Boolean> moveTypeDef(@RequestBody MbrLabelTypeDefMoveRequestParam param);

  @ApiOperation(value = "查询标签列表")
  @RequestMapping(value="/listDef", method = RequestMethod.POST)
  ResponseData<PageInfo<MbrLabelDefVO>> listDef(@RequestBody MbrLabelDefListRequestParam param);

  @ApiOperation(value = "新增标签")
  @RequestMapping(value="/addDef", method = RequestMethod.POST)
  ResponseData<Boolean> addDef(@RequestBody MbrLabelDefAddRequestParam param);

  @ApiOperation(value = "删除标签")
  @RequestMapping(value="/deleteDef", method = RequestMethod.POST)
  ResponseData<Boolean> deleteDef(@RequestParam("mbrLabelDefCode") String mbrLabelDefCode);

  @ApiOperation(value = "更新标签")
  @RequestMapping(value="/updateDef", method = RequestMethod.POST)
  ResponseData<Boolean> updateDef(@RequestBody MbrLabelDefUpdateRequestParam param);

  @ApiOperation(value = "会员贴标签")
  @RequestMapping(value="/addMbrLabel", method = RequestMethod.POST)
  ResponseData<Boolean> addMbrLabel(@RequestBody MbrMemberLabelChangeRequestParam param);

  @ApiOperation(value = "会员撕标签")
  @RequestMapping(value="/deleteMbrLabel", method = RequestMethod.POST)
  ResponseData<Boolean> deleteMbrLabel(@RequestBody MbrMemberLabelDeleteRequestParam param);

  @ApiOperation(value = "会员标签列表")
  @RequestMapping(value="/listMbrLabel", method = RequestMethod.POST)
  ResponseData<List<MbrMemberLabelVO>> listMbrLabel(@RequestParam("mbrMembersCode") String mbrMembersCode);

}