package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@NoArgsConstructor
@AllArgsConstructor
@Data
public class MbrIntegralRuleListRequestParam {

    public MbrIntegralRuleListRequestParam(Boolean status, int pageNum, int pageSize) {
        this.status = status;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型：1-业态，2-商户，3-特殊")
    private Integer scopeType;

    @ApiModelProperty("状态：1-启用，0-禁用")
    private Boolean status;

    private int pageNum = 1;

    private int pageSize  = 10;
}