package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.CouponManualAddRequestParam;
import com.bizvane.members.feign.model.bo.CouponManualListRequestParam;
import com.bizvane.members.feign.model.vo.CouponManualVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/couponManual")
@Api("批量发券")
public interface CouponManualFeign {

  @ApiOperation(value = "新增")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody CouponManualAddRequestParam param);

  @ApiOperation(value = "列表查询")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<CouponManualVO>> list(@RequestBody CouponManualListRequestParam param);

  @ApiOperation(value = "详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<CouponManualVO> detail(@Param("couponManualCode") String couponManualCode);

  @ApiOperation(value = "更新状态")
  @RequestMapping(value="/updateStatus", method = RequestMethod.POST)
  ResponseData<Boolean> updateStatus(@Param("couponManualCode") String couponManualCode, @Param("taskStatus") Integer taskStatus);
}