package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class CouponEntityAddRequestParam {

    @NotEmpty
    @ApiModelProperty("券定义code列表")
    private List<String> couponDefinitionCodeList;

    @NotBlank
    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @NotNull
    @ApiModelProperty("发放类型（10-开卡发券，15-会员生日，20-受赠，25-积分兑换，30-线上开卡，35-会员升级，--40-会员生日，45-会员消费，50-会员签到，55-领券，60-完善资料，65-微信分享，70-消费次数，75-消费金额，80-邀请开卡, 81-调查问卷,85-批量发券,90-入会纪念日,95-定向营销 ，100 - 评价奖励活动，101 - 积分商城，103大转盘，104红包膨胀，105-砸金蛋，106-宝宝生日活动，107-会员首单活动，108-摇一摇，109-储值送礼，110-预生成券，111-员工券，115 - 线下ERP发券，120 - 天猫券，125 - 线下领券 ,130-自动营销, 135-神策发放）")
    private Integer sendType;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

}
