package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 等级定义表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrBenefitsVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("等级编号")
    private String levelNo;

    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("等级排序值")
    private Integer levelValue;

    @ApiModelProperty("卡背景URL")
    private String cardBackUrl;

    @ApiModelProperty("文案颜色")
    private String wordColor;

    @ApiModelProperty("升降级规则开启状态：1-开启；0-关闭")
    private Boolean ruleStatus;

    @ApiModelProperty("升级条件")
    private String upGradeCondition;

    @ApiModelProperty("降级条件")
    private String downGradeCondition;

    private String levelNameList;

    private List<MbrBenefitsLevelVO> mbrBenefitsLevelList;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

}
