package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
public class MbrLevelRecordListRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("操作类型：1-升级，2-降级")
    private Integer opsType;

    @ApiModelProperty("原等级")
    private String originMbrLevelDefCode;

    @ApiModelProperty("当前等级")
    private String currentMbrLevelDefCode;

    @ApiModelProperty("时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDateStart;

    @ApiModelProperty("时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
